(function(){
  'use strict';

  angular.module('ammico', [ 'ngRoute','ammicoHome', 'ammicoGallery', 'ammicoSlideshow', 'ammicoSearch', 'ammicoLogin', 'templates' ])
    .config(function($routeProvider) {
      $routeProvider.
        when('/', {
        controller: 'homeCtrl',
        templateUrl: 'home/home.html'
      }).
      when('/gallery', {
        controller: 'galleryCtrl',
        templateUrl: 'gallery/gallery.html'
      }).
      when('/slideshow/', {
          controller: 'slideshowCtrl',
          templateUrl: 'slideshow/slideshow.html'
      }).
      when('/slideshow/:iSlide', {
          controller: 'slideshowCtrl',
          templateUrl: 'slideshow/slideshow.html'
      }).
      when('/slideshow/edit/:iSlide', {
          controller: 'slideshowCtrl',
          templateUrl: 'slideshow/slideshow.html'
      }).
      when('/slideshow/add/:searched', {
        controller: 'slideshowCtrl',
        templateUrl: 'slideshow/slideshow.html'
      }).
      when('/search/', {
          controller: 'searchCtrl',
          templateUrl: 'search/search.html'
      }).
      when('/search/:q', {
          controller: 'searchCtrl',
          templateUrl: 'search/search.html'
      }).
      when('/login/', {
          controller: 'loginCtrl',
          templateUrl: 'login/login.html'
      }).
      otherwise({
        redirectTo: '/'
      });
    })
    // .config(function ($routeProvider) {
    //   $routeProvider
    //     .otherwise({
    //       redirectTo: '/'
    //   });
    // });
    .config(function($logProvider){
      $logProvider.debugEnabled(true);
    })
    .service('searchApi', function($resource, context) {
        this.searchResource = function(params){
            return $resource(context.urls.searchUrl,  
                {
                    callback: 'JSON_CALLBACK'
                },
                {
                    getJsonp: {
                        method: 'JSONP',
                        params: params,
                        isArray: false,
                        transformResponse: function(data){
                            // Transform meta list into meta dict
                            var nb = data.hits.length;
                            for(var i=0;i<nb;i++){
                                var nb_metas = data.hits[i].metas.length;
                                data.hits[i].metas_dict = {};
                                for(var j=0;j<nb_metas;j++){
                                    if(typeof data.hits[i].metas[j].images==='undefined'){
                                        data.hits[i].metas_dict[data.hits[i].metas[j].name] = data.hits[i].metas[j].value;
                                    }
                                    else{
                                        data.hits[i].metas_dict.images = data.hits[i].metas[j].images[0].value;
                                    }
                                }
                            }
                            return data;
                        }
                    }
                });
        };
        this.getResource = $resource(context.urls.ammicoUrl+'/:action', {action:'@action'});
    });

})();
