(function(){
  'use strict';

  angular.module('ammicoSlideshow',['ngResource', 'ngRoute', 'ui.bootstrap'])
    .config(function ($routeProvider) {
      $routeProvider
        .when('/', {
          templateUrl: 'slideshow/slideshow.html',
          controller: 'slideshowCtrl'
        });
    })
    .service('slideshowApi', function($resource, context) {
      console.log('slideshow 5',this);
      this.slideshow = $resource(context.urls.slideshowUrl);
    })
    .service('slideshowModel', function(slideshowApi) {
      console.log('slideshow 6',this);
      this.slideshow = slideshowApi.slideshow.get();
    })
    .controller('slideshowCtrl', function($scope, $filter, $location, $routeParams, $timeout, searchApi, slideshowModel){
      console.log('slideshow 7', $location, $routeParams, searchApi, slideshowModel);
      $scope.slideshow = slideshowModel.slideshow;
      $scope.iSlide = parseInt($routeParams.iSlide) || 0;
      console.log('$routeParams',$routeParams);
      if(typeof $routeParams.searched !== 'undefined'){
          var a = $routeParams.searched.split(',');
          var q = a[0], i = parseInt(a[1]);
          if(a.length===2 && !isNaN(i)){
              searchApi.searchResource({q:q, of: 'json', synthesis: 'false', nresults:'50', callback: 'JSON_CALLBACK'}).$promise.then(
                  //success
                  function( data ){
                      var hit = data.hits[i];
                      $scope.slideshow.images.push({url: $filter('meta')(hit.metas, 'url'), 
                                                    title: $filter('meta')(hit.metas, 'name'), 
                                                    description: $filter('meta')(hit.metas, 'description'), tags: [], user_title:'', user_description:''});
                      // timeout because
                      $timeout(function(){$scope.slideshow.images[$scope.slideshow.images.length-1].active = true;}, 200);
                  },
                  //error
                  function( error ){
                      alert('Erreur avec la requête (dans slideshow)', error);
                  }
              );
          }
      }
      $timeout(function(){
          if($scope.iSlide>=0 && $scope.iSlide<$scope.slideshow.images.length){
              $scope.slideshow.images[$scope.iSlide].active = true;
              var l = $location.path();
              if(l.substr(0,16)==='/slideshow/edit/'){
                  $scope.slideshow.images[$scope.iSlide].editMode = true;
              }
          }
      }, 200);

      $scope.save = function(){
          console.log('8 call save POST',$scope.slideshow);
          $scope.slideshow
          .$save()
          .then(
              function(response) {
                  console.log('NICE SAVING!', response);
              },
              function(reason){
                  alert('An error occured while saving : ' + reason);
              }
          );
      };
    })
    .directive('slideEditor', function() {
      return {
          restrict: 'AE',
          replace: true,
          scope: false,
          templateUrl: 'slideshow/dataEditor.html',
          //controller: function($scope, $element, $attrs){
          controller: function($scope){
              $scope.slidesave = function(){
                  if(typeof $scope.slide.tags === 'string'){
                      $scope.slide.tags = $scope.slide.tags.split(',');
                  }
                  for (var i = $scope.slide.tags.length - 1; i >= 0; i--) {
                      $scope.slide.tags[i] = $scope.slide.tags[i].trim();
                  }
                  $scope.slide.editMode = false;
                  $scope.save();
              };
              $scope.editSlidesave = function(){
                  if(typeof $scope.slide.tags === 'string'){
                      $scope.slide.tags = $scope.slide.tags.split(',');
                  }
                  for (var i = $scope.slide.tags.length - 1; i >= 0; i--) {
                      $scope.slide.tags[i] = $scope.slide.tags[i].trim();
                  }
                  $scope.slide.editMode = false;
                  $scope.save();
              };
          }
      };
  });

})();
