(function(){
  'use strict';

  angular.module('ammicoSearch',['ngResource', 'ngRoute'])
    .config(function ($routeProvider) {
      $routeProvider
        .when('/', {
          templateUrl: 'search/search.html',
          controller: 'searchCtrl'
        });
    })
    .controller('searchCtrl', function($scope, $location, $routeParams, searchApi){
      console.log('search 6',$scope, $location, $routeParams);
      $scope.q = $routeParams.q || '';
      searchApi.searchResource({q:$scope.q, of: 'json', synthesis: 'false', nresults:'50', callback: 'JSON_CALLBACK'}).$promise.then(
          //success
          function( data ){
              // TEMP : add random pict
              for(var i=data.hits.length-1; i>=0; i--){
                  data.hits[i].url = 'http://placekitten.com/g/' + (100+Math.floor((Math.random()*600)+1)) + '/' + (100+Math.floor((Math.random()*600)+1));
              }
              $scope.results = data;
          },
          //error
          function( error ){
              alert('Erreur avec la requête', error);
          }
      );
      
      $scope.addItem = function(i){
          console.log('addItem',i);
          if($scope.results.hits.length>0 && 0<=i && i<$scope.results.hits.length){
              
          }
      };
    })
    .filter('meta', function() {
        return function(input, metaName) {
            var nb = input.length, i = 0, found = false;
            while(found===false && i<nb){
                if(input[i].name===metaName){
                    found = true;
                    return input[i].value;
                }
                i++;
            }
            return '';
        };
    });

})();
