from rest_framework import serializers

from ammico.models import AmmicoUser, Book, Slide
from ammico.utils import fetchJson
from config import URL_JAMESPOT


class BookSerializer(serializers.ModelSerializer):

    class Meta:
        model = Book
        fields = ('id', 'idArticle', 'title', 'description', 'image', 'date')
        
class SlideSerializer(serializers.ModelSerializer):
    details = serializers.SerializerMethodField('getStopInfo')
    
    def getStopInfo(self, slide):
        stopList = fetchJson(URL_JAMESPOT + '&f=list&o=article&type=stop&itemFormat=article')
        #print (stopList) 
        for stops in stopList:
            if (slide.idStop == stops['idStop']):
                return stops 

    class Meta:
        model = Slide
        fields = ('id', 'book', 'idStop', 'title', 'description', 'comment', 'image', 'date', 'favorite', 'details')