import datetime

from django.db import models
from taggit.managers import TaggableManager

from django.conf import settings


class Book(models.Model):
    user = models.ForeignKey(settings.AUTH_USER_MODEL, related_name = "books")
    exposition = models.ForeignKey("Exposition", related_name = "exposition")
    id_article = models.CharField(max_length=512, blank=True, null=True)
    title = models.CharField(max_length=512, blank=True)
    description = models.CharField(max_length=512, blank=True, null=True)
    image = models.URLField(max_length=2048, blank=True)
    date = models.DateTimeField(default=datetime.datetime.now)
    public = models.BooleanField(default=False, db_index=True)
    parent_visit = models.ForeignKey('Book', related_name = "books_copy", blank=True, null=True)
    
    def __str__(self):
        return self.title

class Slide(models.Model):
    book = models.ForeignKey(Book, related_name = "slides")
    id_stop = models.CharField(max_length=512, blank=True)
    id_inventory = models.CharField(max_length=512, blank=True)
    title = models.CharField(max_length=512, blank=True)
    description = models.CharField(max_length=1024, blank=True)
    image = models.URLField(max_length=2048, blank=True)
    date = models.DateTimeField(default=datetime.datetime.now)
    favorite = models.BooleanField(default=False, db_index=True)
    tags = TaggableManager(blank=True)
    
    def __str__(self):
        return self.id_stop
    
    class Meta:
        order_with_respect_to = 'book'
        
class Exposition(models.Model):
    title = models.CharField(max_length=512, blank=True)
    description = models.CharField(max_length=1024, blank=True)
    url_exalead = models.URLField(max_length=2048, blank=True)
    url_orpheo = models.URLField(max_length=2048, blank=True)
    url_jamespot = models.URLField(max_length=2048, blank=True)
    active = models.BooleanField(default=True, db_index=True)
    
    def __str__(self):
        return self.title