from django.core.cache import cache
import requests
import json

def fetchJson(url):
    cached = cache.get(url)
    content = ""
    if not cached:
        r = requests.get(url)
        if(r.ok):
            cache.set(url, r.content)
            content = r.content
        else:
            # Write some proper error handling code here
            print ("Error - status code: " + r.status_code)  
    else:
        # Return the cached content
        content = cached

    return json.loads(content.decode('utf-8'))['VAL']