
from datetime import datetime
import json

#from django.contrib.auth import login, logout
from django.contrib.auth.models import User
from django.http import HttpResponse
from django.utils.dateparse import parse_datetime
import requests
from rest_framework import permissions
from rest_framework.response import Response
from rest_framework.views import APIView

from ammico.models import Book, AmmicoUser, Slide
from ammico.serializers import BookSerializer, SlideSerializer
from settings import URL_JAMESPOT


def populateUser(request):
    usermail = request.GET["email"]
    user = AmmicoUser.objects.get(user=User.objects.get(email=usermail))
    data = {"user": usermail, "idUser": user.idUser}
    populateVisite(user)
    return HttpResponse(content=json.dumps(data), content_type='application/json')

def populateVisite(user):
    # send request with usermail to get the visites of this user and add it to the database 
    #r = requests.get('http://fui-ammico.jamespot.pro/api/api.php?&k=6c8bfcea247e8a5841288269887d88f0&d=2016-01-31&m=EXT-IRI&v=2.0&f=get&o=article&idArticle=169')

    #simulate the request
    params = {'o': 'article', 'f': 'list', 'idUser': user.idUser} 
    r = requests.get(URL_JAMESPOT, params=params)
    visites = json.loads(r.content.decode('utf-8'))
    
    for visite in visites['VAL']:
        params = {'o' : 'article', 'f' : 'get', 'idArticle' : visite['idArticle']}
        r = requests.get(URL_JAMESPOT, params=params)
        visiteInfo = json.loads(r.content.decode('utf-8'))['VAL']
        book, _ = Book.objects.update_or_create(
            user=user, 
            idArticle=visiteInfo['idArticle'],
            defaults={
                'title' : visiteInfo['title'],
                'description' : visiteInfo['description'],
                'image' : visiteInfo['image'],
                'date' : parse_datetime(visiteInfo['dateCreation'])
            }
        )
        populateSlide(json.loads(visiteInfo['steps']), book)

def populateSlide(steps, book):
    for step in steps:
        if (step['stop'] != None and step['stop'] != ''):
            
            if 'comment' in step:
                comment = step['comment']
            else:
                comment = ""
            
            Slide.objects.update_or_create(
                book=book,
                idStop=step['stop'],
                defaults={
                    'comment' : comment,
                    'date' : parse_datetime(str(datetime.strptime(step['DATE'] + " " + step['TIME'], "%d/%m/%Y %H:%M:%S")))
                }
            )
            
class ListBooks(APIView):
    """
    Views to list all books.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def get(self, request):
        """
        Return a list of all Books.
        """
        books = Book.objects.all()
        serializer = BookSerializer(books, many=True)
        return Response(serializer.data)

class InfoBook(APIView):
    """
    View to get book informations.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def get(self, request, idBook):
        try:
            book = Book.objects.get(id=idBook)
        except Book.DoesNotExist:
            return HttpResponse(status=404)
        
        serializer = BookSerializer(book)
        return Response(serializer.data)
    
class GetSlides(APIView):
    """
    View to get book informations.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def get(self, request, idBook):
        try:
            book = Book.objects.get(id=idBook)
        except Book.DoesNotExist:
            return HttpResponse(status=404)
        print(book)
        
        serializer = SlideSerializer(book.slides.all(), many=True)
        return Response(serializer.data)

class ListSlides(APIView):
    """
    Views to list all books.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def get(self, request, format=None):
        """
        Return a list of slide
        """               
        slides = Slide.objects.filter()
        serializer = SlideSerializer(slides, many=True)
        return Response(serializer.data)

class InfoSlide(APIView):
    """
    View to get book informations.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def get(self, request, idSlide):
        try:
            slide = Slide.objects.get(id=idSlide)
        except Slide.DoesNotExist:
            return HttpResponse(status=404)
        
        serializer = SlideSerializer(slide)
        return Response(serializer.data)
    