(function(){
	'use strict';

	angular.module('ammicoAuth',['ngRoute'])
	.controller('authCtrl', function($location, $rootScope, $routeParams, $modal){
		$modal.open({
			templateUrl: 'auth/' + $routeParams.action + '_modal.html',
			controller: 'auth' + $routeParams.action + 'Ctrl'
		}).result.then(function (result) {
			$location.path(result);
		}, function () {
			$location.path('/');
		});
	})
	.controller('authloginCtrl', function($modalInstance, $scope, authApi, $window, $http, $rootScope){
		$scope.login = function(){
			authApi.login.save({username:$scope.username, password:$scope.password}, function(data){
				$rootScope.globals.userLogged = true;
				$window.sessionStorage.token = data.token;
				$http.defaults.headers.common.Authorization = 'Token ' + $window.sessionStorage.token;
				$modalInstance.close('/books');
			});
		};
		$scope.register = function () {
			$modalInstance.close('/auth/register');
		};
		$scope.cancel = function () {
			$modalInstance.close('/');
		};
	})
	.controller('authlogoutCtrl', function($modalInstance, $scope, $window, $http, $rootScope){
		delete $window.sessionStorage.token;
		$rootScope.globals.userLogged = false;
		delete $http.defaults.headers.common.Authorization;

		$scope.cancel = function () {
			$modalInstance.close('/');
		};
	})
	.controller('authregisterCtrl', function($scope, $modalInstance, authApi){
		$scope.register = function () {
			authApi.user.save({
				username: $scope.username,
				email: $scope.email,
				password: $scope.password,
			}, function(){
				$modalInstance.close('/auth/login');
			});
		};
		$scope.back = function () {
			$modalInstance.close('/auth/login');
		};
	});
})();
