(function(){
	'use strict';

	angular.module('ammicoVisites',['ngRoute', 'ui.sortable'])
	.controller('visitesCtrl', function($scope, $location, $modal, ammicoApi){

		//get list book
		$scope.books = ammicoApi.listBooks.query({format:'json'}, function(data){
			data.sort(function (a, b) {
				return a.date < b.date;
			});

			for (var i = 0; i < data.length; i++) {
		    	if (data[i].idArticle){
		    		data[i].slides = ammicoApi.booksSlides.query({idBook:data[i].id, format:'json'});
		    	}
			}	
		});

		$scope.toggleModal = function (index) {

			var modalInstance = $modal.open({
				templateUrl: 'visites/add_book_modal.html',
				controller: 'ModalAddVisitesCtrl',
				size: 'sm'
			});

			modalInstance.result.then(function (idBook) {
				var newSlide = {
					book: idBook,
					idInventory: $scope.results.hits[index].metas_dict.inventorynumber
				};
				ammicoApi.listSlides.save(newSlide);
			});
		};


		$scope.addBook = function (idParent) {
			$modal.open({
				templateUrl: 'visites/add_modal_visites.html',
				controller: 'ModalAddVisitesCtrl'
			}).result.then(function (title) {
				//add book with the title written in the modal
				ammicoApi.listBooks.save({idParent:idParent, title: title}, function(newBook){
					$scope.books.push(newBook);
				});
			});
		};
		
	})


  .controller('visiteCtrl', function($scope, ammicoApi, $routeParams, $modal) {
		//get the slides of a book
		$scope.slides = ammicoApi.booksSlides.query({idBook:$routeParams.idVisit, format:'json'}, function(data){
			data.sort(function (a, b) {
				return a.orderIndex > b.orderIndex;
			});
			
		});


		$scope.toggleModal = function (index) {

			var modalInstance = $modal.open({
				templateUrl: 'visites/add_book_modal.html',
				controller: 'ModalAddVisitesCtrl',
				size: 'sm'
			});

			modalInstance.result.then(function (idBook) {
				var newSlide = {
					book: idBook,
					idInventory: $scope.results.hits[index].metas_dict.inventorynumber
				};
				ammicoApi.listSlides.save(newSlide);
			});
		};

		$scope.addBook = function (idParent) {
			$modal.open({
				templateUrl: 'visites/add_modal_visites.html',
				controller: 'ModalAddVisitesCtrl'
			}).result.then(function (title) {
				//add book with the title written in the modal
				ammicoApi.listBooks.save({idParent:idParent, title: title}, function(newBook){
					$scope.books.push(newBook);
				});
			});
		};
		
		$scope.sortableOptions = {
				stop: function() {
					var order = $scope.slides.map(function(i){
						return i.id;
					});
					ammicoApi.order.save({idBook:$routeParams.idVisit}, {order: order});
				}
		};



		$scope.deleteItem = function(i){
			if(0<=i && i<$scope.slides.length){
				if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
					//delete a slide
					ammicoApi.slide.delete({idSlide: $scope.slides[i].id}, function(){
						$scope.slides.splice(i, 1);
					},
					function(error) {
						if (error.status === 404){
							$scope.slides.splice(i, 1);
						}
					});
				}
			}
		};

	})


	.controller('ModalAddVisitesCtrl', function($scope, ammicoApi, $modalInstance) {

		$scope.add = function(){
			$modalInstance.close($scope.title);
//			ammicoApi.listBooks.save({title: $scope.title}, function(newBook){
//			});
		};
		$scope.cancel = function () {
			$modalInstance.dismiss('cancel');
		};

		$scope.books = ammicoApi.listBooks.query({format:'json'});
		
		$scope.addToBook = function(idBook){
			$modalInstance.close(idBook);
		};

		$scope.cancel = function () {
			$modalInstance.dismiss('cancel');
		};

	
	});

})();
