(function(){
	'use strict';

	angular.module('ammicoBooks',['ngRoute', 'ui.sortable'])
	.controller('booksCtrl', function($scope, $location, $modal, ammicoApi){
		$scope.books = ammicoApi.listBooks.query({format:'json'}, function(data){
			data.sort(function (a, b) {
				return a.date < b.date;
			});

			for (var i = 0; i < data.length; i++) {
		    	if (data[i].idArticle === null){
		    		data[i].slides = ammicoApi.booksSlides.query({idBook:data[i].id, format:'json'});
		    	}
			}	
		});

		$scope.toggleModal = function (index) {

			var modalInstance = $modal.open({
				templateUrl: 'books/add_book_modal.html',
				controller: 'ModalAddBookCtrl',
				size: 'sm'
			});

			modalInstance.result.then(function (idBook) {
				var newSlide = {
					book: idBook,
					idInventory: $scope.results.hits[index].metas_dict.inventorynumber
				};
				ammicoApi.listSlides.save(newSlide);
			});
		};
		
		$scope.searchSubmit = function(){
			$location.path('/search/' + $scope.q);
		};

		$scope.addBook = function (idParent) {
			$modal.open({
				templateUrl: 'books/add_modal.html',
				controller: 'ModalAddBookCtrl'
			}).result.then(function (title) {
				ammicoApi.listBooks.save({idParent:idParent, title: title}, function(newBook){
					$scope.books.push(newBook);
				});
			});
		};
		$scope.deleteItem = function(book){
			if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
				ammicoApi.book.delete({idBook: book.id}, function(){
					$scope.books.splice($scope.books.indexOf(book), 1);
				},
				function(error) {
					if (error.status === 404){
						$scope.books.splice($scope.books.indexOf(book), 1);
					}
				});
			}
		};
	})

	.controller('bookCtrl', function($scope, $location, ammicoApi, $routeParams, $modal) {
		$scope.parentBook = ammicoApi.book.get({idBook:$routeParams.idBook, format:'json'}, function(data){
			data.slides = ammicoApi.booksSlides.query({idBook: data.id, format:'json'}, function(data){
				data.sort(function (a, b) {
					return a.orderIndex > b.orderIndex;
				});
			});
		});
		
		$scope.toggleFavorite = function (index) {

		    $scope.parentBook.slides[index].favorite = !$scope.parentBook.slides[index].favorite;
		    $scope.parentBook.slides[index].$save({format:'json'});
		    //$scope.slide.$save({idSlide:$scope.slide.id, format:'json'});
        };

		$scope.toggleModal = function (index) {

			var modalInstance = $modal.open({
				templateUrl: 'books/add_book_modal.html',
				controller: 'ModalAddBookCtrl',
				size: 'sm'
			});

			modalInstance.result.then(function (idBook) {
				var newSlide = {
					book: idBook,
					idInventory: $scope.results.hits[index].metas_dict.inventorynumber
				};
				ammicoApi.listSlides.save(newSlide);
			});
		};

		$scope.sortableOptions = {
				stop: function() {
					var order = $scope.parentBook.slides.map(function(i){
						return i.id;
					});
					ammicoApi.order.save({idBook:$routeParams.idBook}, {order: order});
				}
		};

		$scope.deleteItem = function(i){
		    if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
		        $scope.parentBook.slides[i].$delete();
			//if(0<=i && i<$scope.slides.length){
//					ammicoApi.slide.delete({idSlide: $scope.slides[i].id}, function(){
//						$scope.slides.splice(i, 1);
//					},
//					function(error) {
//						if (error.status === 404){
//							$scope.slides.splice(i, 1);
//						}
//					});
//				}
			}
		};
	})
	.controller('ModalAddBookCtrl', function ($scope, ammicoApi, $modalInstance) {

		$scope.add = function(){
			$modalInstance.close($scope.title);
//			ammicoApi.listBooks.save({title: $scope.title}, function(newBook){
//			});
		};
		$scope.cancel = function () {
			$modalInstance.dismiss('cancel');
		}
		;
		$scope.books = ammicoApi.listBooks.query({format:'json'});
		
		$scope.addToBook = function(idBook){
			$modalInstance.close(idBook);
		};

		$scope.cancel = function () {
			$modalInstance.dismiss('cancel');
		};
	});
})();
