
from django.http import HttpResponse
import requests
import json
from datetime import datetime
from django.utils.dateparse import parse_datetime
from django.contrib.auth.models import User
from models import Book, AmmicoUser, Slide
from serializers import BookSerializer, SlideSerializer

from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import authentication, permissions

def populateUser(request):
    usermail = request.GET["usermail"]
    user = AmmicoUser.objects.get(user=User.objects.get(email=usermail))
    data = {"user": usermail, "idUser": user.idUser}
    populateVisite(user)
    return HttpResponse(content=json.dumps(data), content_type='application/json')

def populateVisite(user):
    # send request with usermail to get the visites of this user and add it to the database 
    #r = requests.get('http://fui-ammico.jamespot.pro/api/api.php?&k=6c8bfcea247e8a5841288269887d88f0&d=2016-01-31&m=EXT-IRI&v=2.0&f=get&o=article&idArticle=169')

    #simulate the request
    r = requests.get('http://fui-ammico.jamespot.pro/api/api.php?&k=6c8bfcea247e8a5841288269887d88f0&d=2016-01-31&m=EXT-IRI&v=2.0&o=article&f=list&idUser='+user.idUser)
    visites = json.loads(r.content)
    
    for visite in visites['VAL']:
        r = requests.get('http://fui-ammico.jamespot.pro/api/api.php?&k=6c8bfcea247e8a5841288269887d88f0&d=2016-01-31&m=EXT-IRI&v=2.0&o=article&f=get&idArticle='+visite['idArticle'])
        visiteInfo = json.loads(r.content)['VAL']
        book, _ = Book.objects.get_or_create(
            user=user, 
            idArticle=visiteInfo['idArticle'],
            title=visiteInfo['title'],
            description=visiteInfo['description'],
            image=visiteInfo['image'],
            date=parse_datetime(visiteInfo['dateCreation'])
        )
        populateSlide(json.loads(visiteInfo['steps']), book)

def populateSlide(steps, book):
    for step in steps:
        if (step['stop'] != None and step['stop'] != ''):
            
            if 'comment' in step:
                comment = step['comment']
            else:
                comment = ""
            
            print datetime.strptime(step['DATE'] + " " + step['TIME'], "%d/%m/%Y %H:%M:%S")
            
            Slide.objects.get_or_create(
                book=book,
                idStop=step['stop'],
                comment=comment,
                date=parse_datetime(str(datetime.strptime(step['DATE'] + " " + step['TIME'], "%d/%m/%Y %H:%M:%S")))
            )
            
class ListBooks(APIView):
    """
    Views to list all books.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def get(self, request, format=None):
        """
        Return a list of all Books.
        """
        books = Book.objects.all()
        serializer = BookSerializer(books, many=True)
        return Response(serializer.data)

class InfoBook(APIView):
    """
    View to get book informations.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def get(self, request, id):
        try:
            book = Book.objects.get(id=id)
        except Book.DoesNotExist:
            return HttpResponse(status=404)
        
        serializer = BookSerializer(book)
        return Response(serializer.data)

class ListSlides(APIView):
    """
    Views to list all books.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def get(self, request, format=None):
        """
        Return a list of all Books.
        """
        slides = Slide.objects.all()
        serializer = SlideSerializer(slides, many=True)
        return Response(serializer.data)

class InfoSlide(APIView):
    """
    View to get book informations.
    """
    #authentication_classes = (authentication.TokenAuthentication,)
    #permission_classes = (permissions.IsAdminUser,)
    permission_classes = (permissions.IsAuthenticatedOrReadOnly,)

    def get(self, request, id):
        try:
            slide = Slide.objects.get(id=id)
        except Slide.DoesNotExist:
            return HttpResponse(status=404)
        
        serializer = SlideSerializer(slide)
        return Response(serializer.data)