import json

import requests
from rest_framework import serializers

from ammico.models import AmmicoUser, Book, Slide
from ammico.utils import fetchJson
from config import URL_EXALEAD
from config import URL_JAMESPOT


class BookSerializer(serializers.ModelSerializer):
    
    class Meta:
        model = Book
        fields = ('id', 'idArticle', 'title', 'description', 'image', 'date')
        
class SlideSerializer(serializers.ModelSerializer):
    details = serializers.SerializerMethodField('getStopInfo')
    index = serializers.SerializerMethodField('getOrder')
    
    def getStopInfo(self, slide):
        if (slide.idInventory != ""):
            return extractFromMIMO(slide)
        else:
            return extractFromJameSpot(slide)
        
    def getOrder(self, slide):
        return slide.book.get_slide_order().index(slide.id)

    class Meta:
        model = Slide
        fields = ('id', 'index', 'book', 'idStop', 'idInventory', 'title', 'description', 'comment', 'image', 'date', 'favorite', 'details')
        

def extractFromMIMO(slide):
    details = {}
    params = {'of': 'json', 'q': 'record_inventorynumber:' + slide.idInventory} 
    data = requests.get(URL_EXALEAD, params=params)
    results = json.loads(data.content.decode('utf-8'))
    if (len(results['hits']) == 1):
        for i in results['hits'][0]['metas']:
            if('images' not in i):
                details[i['name']] = i['value']
            else:
                details['images'] = i['images'][0]['value']           
        details['title'] = details.pop('name')
    return details

def extractFromJameSpot(slide):
    details={}
    stopList = fetchJson(URL_JAMESPOT + '&f=list&o=article&type=stop&itemFormat=article')
    for stops in stopList:
        if (slide.idStop == stops['idStop']):
            details = stops
            details['images'] = details.pop('firstImg')
            details['description'] = details.pop('captionImg')
    return details