(function(){
	'use strict';

	angular.module('ammicoBooks',['ngRoute', 'ui.sortable'])
	.service('booksModel', function(searchApi) {
		this.books = searchApi.listBooks.query({format:'json'}); 
	})
	.controller('booksCtrl', function($scope, $location, booksModel){
		$scope.books = booksModel.books;
		$scope.searchSubmit = function(){
			$location.path('/search/' + $scope.q);
		};
	})
	.controller('bookCtrl', function($scope, searchApi, $routeParams) {
		$scope.slides = searchApi.booksSlides.query({idBook:$routeParams.idBook, format:'json'});
		$scope.slides.sort(function (a, b) {
		    return a.orderIndex > b.orderIndex;
		  });
		$scope.sortableOptions = {
		    stop: function() {
		    	var order = $scope.slides.map(function(i){
		            return i.id;
		    	});
		    	searchApi.order.save({idBook:$routeParams.idBook}, {order: order});
		    }
		};
		
		$scope.deleteItem = function(i){
			if(0<=i && i<$scope.slides.length){
				if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
					searchApi.slide.delete({idSlide: $scope.slides[i].id}, function(){
						$scope.slides.splice(i, 1);
					});
				}
			}
		};
	});
})();
